{-----------------------------------------------------------------------}
{ Copyright  1995 by Software Source. All Rights Reserved              }
{ Delphi conversion by Gregg Irwin [72450,676]                          }
{                                                                       }
{ Note: This code is intended for demonstration purposes only.          }
{       It is a port of a C program to Delphi by a VB programmer so     }
{       don't expect it to win any awards.<g>                           }
{                                                                       }
{       You'll see that the event procedures are one-liners. All the    }
{       functionality is in user defined functions. This should make it }
{       much easier to extract pieces for reuse. It's also a good idea  }
{       to separate the working code from the UI whenever possible.     }
{-----------------------------------------------------------------------}
unit CBDelTst;

{$X+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CBISAM, Grids, StdCtrls, Buttons;

{ Indexed fields in the type *must* be "array of char"
  or sorting won't work correctly}
type
  TPerson = record
     tVBufCB:     T_VBUFCB;   { required element      }
     Name:        array[0..51] of char; { String[51]; }
     LastName:    String[30]; { array[0..30] of char; }
     FirstName:   String[20]; { array[0..20] of char; }
     Address:     String[40]; { array[0..40] of char; }
     City:        array[0..30] of char; { String[30]; }
     State:       array[0..2]  of char; { String[2];  }
     Zip:         array[0..10] of char; { String[10]; }
     Phone:       array[0..20] of char; { String[20]; }
     Notes:       T_VSTR;
  end;

type
  TfrmMain = class(TForm)
    lblLastName: TLabel;
    lblFirstName: TLabel;
    lblAddress: TLabel;
    cmdExit: TButton;
    lblCityStZip: TLabel;
    txtLastName: TEdit;
    txtFirstName: TEdit;
    txtAddress: TEdit;
    txtCity: TEdit;
    txtState: TEdit;
    txtZip: TEdit;
    lblPhone: TLabel;
    txtPhone: TEdit;
    cmdPrevious: TBitBtn;
    cmdNext: TBitBtn;
    lblStatus: TLabel;
    cmdFirst: TBitBtn;
    cmdLast: TBitBtn;
    cmdAddNew: TButton;
    cmdModify: TButton;
    cmdDelete: TButton;
    cmdClear: TButton;
    optIndexName: TRadioButton;
    optIndexCity: TRadioButton;
    optIndexPhone: TRadioButton;
    optIndexZip: TRadioButton;
    lblNotes: TLabel;
    txtNotes: TMemo;
    optIndexState: TRadioButton;
    optIndexPrimary: TRadioButton;
    lblPrimaryKey: TLabel;
    { EVENTS }
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure cmdAddNewClick(Sender: TObject);
    procedure cmdClearClick(Sender: TObject);
    procedure cmdDeleteClick(Sender: TObject);
    procedure cmdExitClick(Sender: TObject);
    procedure cmdFirstClick(Sender: TObject);
    procedure cmdLastClick(Sender: TObject);
    procedure cmdModifyClick(Sender: TObject);
    procedure cmdNextClick(Sender: TObject);
    procedure cmdPreviousClick(Sender: TObject);
    procedure optIndexCityClick(Sender: TObject);
    procedure optIndexNameClick(Sender: TObject);
    procedure optIndexPhoneClick(Sender: TObject);
    procedure optIndexPrimaryClick(Sender: TObject);
    procedure optIndexStateClick(Sender: TObject);
    procedure optIndexZipClick(Sender: TObject);
    { INTERNAL PROCEDURES }
    procedure AddNewRec;
    function  BuildRecord(var Person: TPerson): Integer;
    procedure ClearDisplay;
    procedure DeleteCurrentRec;
    procedure ModifyRec;
    procedure MoveFirst;
    procedure MoveLast;
    procedure MoveNext;
    procedure MovePrevious;
    procedure MoveToRec (MoveOp: Integer);
    procedure ShowRecord (PrimaryKey: PChar; var Person: TPerson);
    procedure Shutdown;
    procedure Startup;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  TPerson_Fmt:       PChar   = 'X$*51,$*30,$*20,$*40,X$*30,X$*2,X$*10,X$*20,$';
  TPerson_MaxKeyLen: Integer = 10;
  TPerson_Filename:  PChar   = 'CBDELTST.ISD';
  IDX_PRIMARY:       Integer = 0; { Primary Index }
  IDX_NAME:          Integer = 1;
  IDX_CITY:          Integer = 5;
  IDX_STATE:         Integer = 6;
  IDX_ZIP:           Integer = 7;
  IDX_PHONE:         Integer = 8;
var
  frmMain: TfrmMain;
  nDatasetNumber: Integer; { Dataset Handle }
  nCurrentIndex:  Integer; { Current Index  }

implementation

{$R *.DFM}

{===========================================================}
{  EVENTS                                                   }
{===========================================================}

{ FORM }

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Shutdown;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
     Startup;
end;

{ COMMAND BUTTONS }

procedure TfrmMain.cmdAddNewClick(Sender: TObject);
begin
     AddNewRec;
end;

procedure TfrmMain.cmdClearClick(Sender: TObject);
begin
     ClearDisplay;
end;

procedure TfrmMain.cmdDeleteClick(Sender: TObject);
begin
     DeleteCurrentRec;
end;

procedure TfrmMain.cmdExitClick(Sender: TObject);
begin
     frmMain.Close;
end;

procedure TfrmMain.cmdFirstClick(Sender: TObject);
begin
     MoveFirst;
end;

procedure TfrmMain.cmdLastClick(Sender: TObject);
begin
     MoveLast
end;

procedure TfrmMain.cmdModifyClick(Sender: TObject);
begin
     ModifyRec;
end;

procedure TfrmMain.cmdNextClick(Sender: TObject);
begin
     MoveNext;
end;

procedure TfrmMain.cmdPreviousClick(Sender: TObject);
begin
     MovePrevious;
end;

{ OPTION BUTTONS }

procedure TfrmMain.optIndexCityClick(Sender: TObject);
begin
     nCurrentIndex := IDX_CITY;
end;

procedure TfrmMain.optIndexNameClick(Sender: TObject);
begin
     nCurrentIndex := IDX_NAME;
end;

procedure TfrmMain.optIndexPhoneClick(Sender: TObject);
begin
     nCurrentIndex := IDX_PHONE;
end;

procedure TfrmMain.optIndexPrimaryClick(Sender: TObject);
begin
     nCurrentIndex := IDX_PRIMARY;
end;

procedure TfrmMain.optIndexStateClick(Sender: TObject);
begin
     nCurrentIndex := IDX_STATE;
end;

procedure TfrmMain.optIndexZipClick(Sender: TObject);
begin
     nCurrentIndex := IDX_ZIP;
end;

{===========================================================}
{  INTERNAL PROCEDURES                                      }
{===========================================================}

{-----------------------------------------}
{  AddNewRec                              }
{-----------------------------------------}
procedure TfrmMain.AddNewRec;
var
   rc:            Integer;
   ErrTextBuffer: array [0..25] of char;
   PrimaryKey:    array [0..255] of char;
   tRec:          TPerson;
   RecNum:        LongInt;
   tmpBuf:        String[10];
begin
   { Generate a new unique ID by going to the end of the file, getting the
     ID of the last record, and adding 1 to it. }
   rc := VmxEOF(nDatasetNumber, IDX_PRIMARY);
   if (rc = VIS_OK) then
      begin
         rc := VmxGet(nDatasetNumber,     { int    DatasetNumber     }
                      IDX_PRIMARY,        { int    PrimaryIndex      }
                      XPREVIOUS
                        or XTEXT
                        or XNO_DATA,      { int    OptionParameter   }
                      '',                 { Don't need a Selector param with these options }
                      '',                 { Don't need returned index entry in this case   }
                      PrimaryKey,         { LPSTR  lpPriKey          }
                      @tRec,              { LPVOID lpRecordStructure }
                      sizeof(tRec));      { size of record structure }

         VmxReturnCode(rc, ErrTextBuffer);
         lblStatus.Caption := ErrTextBuffer;

         if (rc = VIS_OK) then
            { We got the last record OK }
            begin
               RecNum := StrToInt('$' + StrPas(PrimaryKey)) + 1;
            end
         else
             if (rc = VIS_NOT_FOUND) then
                { No records in the file }
                begin
                   RecNum := 1;
                   rc := VIS_OK;
                end
             else
                { We have a real error on our hands }
                begin
                   VmxReturnCode(rc, ErrTextBuffer);
                   lblStatus.Caption := ErrTextBuffer;
                end;

         { If we're OK at this point then we have a new ID to use }
         if (rc = VIS_OK) then
            begin
               { Turn the ID into a hex number (not strictly necessary) }
               tmpBuf := IntToHex(RecNum, TPerson_MaxKeyLen);
               { Copy the ID into our outgoing variable }
               StrPCopy(PrimaryKey, tmpBuf);
               { Grab the data off the screen }
               rc := BuildRecord(tRec);
               if (rc = VIS_OK) then
                   { Write the record using ADD mode }
                   rc := VmxPut(nDatasetNumber,    { int   DatasetNumber                          }
                                PrimaryKey,        { LPSTR lpKey                                  }
                                @tRec,             { LPSTR lpRecordStructure                      }
                                sizeof(tRec),      { size of tRec                                 }
                                ADD_ONLY           { updatemode already set                       }
                                  or XTEXT);       { zero  terminated strings (fixed len strings) }
                   if rc = VIS_OK then
                      frmMain.lblPrimaryKey.Caption := StrPas(PrimaryKey)
                   else
                      begin
                         VmxReturnCode(rc, ErrTextBuffer);
                         lblStatus.Caption := ErrTextBuffer;
                         MessageDlg(ErrTextBuffer, mtWarning, [mbOK], 0);
                      end;

               { Not real hygienic to dispose of this here I guess
                 but again, this is just a demonstration. <g> }
               StrDispose(tRec.Notes.lpData);

               { Gotta do that FreeBuf thang }
               rc := VmxFreeBuf(tRec.tVBufCB);
               if (rc <> VIS_OK) then
                 begin
                      VmxReturnCode(rc, ErrTextBuffer);
                      lblStatus.Caption := ErrTextBuffer;
                 end;
            end;
      end;

end;

{-----------------------------------------}
{  BuildRecord                            }
{-----------------------------------------}
function TfrmMain.BuildRecord(var Person: TPerson): Integer;
var
   rc:   Integer;
   tmpNotes: PChar;
begin
    { Copy data from edit boxes into record structure }

    { We have to use StrPCopy if the fields are defined as an array
      of chars, otherwise we can just assign them directly. }
    Person.LastName  := frmMain.txtLastName.Text;
    Person.FirstName := frmMain.txtFirstName.Text;
    Person.Address   := frmMain.txtAddress.Text;
    StrPCopy(Person.City, frmMain.txtCity.Text);
    StrPCopy(Person.State, frmMain.txtState.Text);
    StrPCopy(Person.Zip, frmMain.txtZip.Text);
    StrPCopy(Person.Phone, frmMain.txtPhone.Text);

    { We allocate the string here but it gets disposed after the
      record is written out in the calling procedure }
    Person.Notes.nLen := Length(frmMain.txtNotes.Text);
    tmpNotes := StrAlloc(Person.Notes.nLen + 1);
    Person.Notes.lpData := StrPCopy(tmpNotes, frmMain.txtNotes.Text);

    { We construct the "name" index field by concatenating lastname, binary
       2, and firstname.  Binary 2  (control-B) is the lowest-sorting
       character legal for use in keys.
      Again, we have to use StrPCopy and if we use an array of chars }
    StrPCopy(Person.Name, Person.LastName + Chr(2) + Person.FirstName);

    { use Strlen on char arrays, Length on Pascal Strings }
    if (StrLen(Person.Name) > 0) then
      rc := 0
    else
      rc := 1;

    BuildRecord := rc;

end;

{-----------------------------------------}
{  ClearDisplay                           }
{-----------------------------------------}
procedure TfrmMain.ClearDisplay;
begin
    frmMain.lblPrimaryKey.Caption := '';
    frmMain.txtLastName.Text := '';
    frmMain.txtFirstName.Text := '';
    frmMain.txtAddress.Text := '';
    frmMain.txtCity.Text := '';
    frmMain.txtState.Text := '';
    frmMain.txtZip.Text := '';
    frmMain.txtPhone.Text := '';
    frmMain.txtNotes.Text := '';
end;

{-----------------------------------------}
{  DeleteCurrentRec                       }
{-----------------------------------------}
procedure TfrmMain.DeleteCurrentRec;
var
   rc:            Integer;
   ErrTextBuffer: array [0..25] of char;
   PrimaryKey:    array [0..255] of char;
   tRec:          TPerson;
begin
     { Grab the ID of the record that's currently displayed }
     rc := VmxGet(nDatasetNumber,     { int DatasetNumber        }
                  nCurrentIndex,      { int SelectedIndex        }
                  XCURRENT
                    or XTEXT
                    or XNO_DATA,      { int OptionParameter      }
                  '',                 { Don't need a Selector param with these options }
                  '',                 { Don't need returned index entry in this case   }
                  PrimaryKey,         { LPSTR  lpPriKey          }
                  @tRec,              { LPVOID lpRecordStructure }
                  sizeof(tRec));      { size of record structure }

      if (rc = VIS_OK) then
         begin
            rc := VmxFreeBuf(tRec.tVBufCB);
            if (rc <> VIS_OK) then
              begin
                   VmxReturnCode(rc, ErrTextBuffer);
                   lblStatus.Caption := ErrTextBuffer;
              end;
            { Delete the record }
            rc := VmxDelete(nDatasetNumber, PrimaryKey);
            VmxReturnCode(rc, ErrTextBuffer);
            lblStatus.Caption := ErrTextBuffer;
            if rc = VIS_OK then
               begin
                    { Clear the data for the deleted record and
                      display the next record (if we can that is). }
                    ClearDisplay;
                    MoveNext;
               end
            else
               MessageDlg(ErrTextBuffer, mtWarning, [mbOK], 0);
         end;
end;

{-----------------------------------------}
{  ModifyRec                              }
{-----------------------------------------}
procedure TfrmMain.ModifyRec;
var
   rc:            Integer;
   ErrTextBuffer: array [0..25] of char;
   PrimaryKey:    array [0..255] of char;
   tRec:          TPerson;
begin
     { Grab the ID of the record that's currently displayed }
     rc := VmxGet(nDatasetNumber,     { int    DatasetNumber     }
                  nCurrentIndex,      { int    SelectedIndex     }
                  XCURRENT
                    or XTEXT
                    or XNO_DATA,      { int    OptionParameter   }
                  '',                 { Don't need a Selector param with these options }
                  '',                 { Don't need returned index entry in this case   }
                  PrimaryKey,         { LPSTR  lpPriKey          }
                  @tRec,              { LPVOID lpRecordStructure }
                  sizeof(tRec));      { size of record structure }

      if (rc = VIS_OK) then
            begin
               { Grab the data off the screen }
               rc := BuildRecord(tRec);
               if (rc = VIS_OK) then
                   { Write the record using REPLACE mode }
                   rc := VmxPut(nDatasetNumber,    { int   DatasetNumber                          }
                                PrimaryKey,        { LPSTR lpKey                                  }
                                @tRec,             { LPSTR lpRecordStructure                      }
                                sizeof(tRec),      { size of tRec                                 }
                                REPLACE_ONLY       { updatemode                                   }
                                  or XTEXT);       { zero  terminated strings (fixed len strings) }
               if rc <> VIS_OK then
                  begin
                     VmxReturnCode(rc, ErrTextBuffer);
                     lblStatus.Caption := ErrTextBuffer;
                     MessageDlg(ErrTextBuffer, mtWarning, [mbOK], 0);
                  end;

               { Not real hygienic to dispose of this here I guess
                 but again, this is just a demonstration. <g> }
               StrDispose(tRec.Notes.lpData);

               { Gotta do that FreeBuf thang }
               rc := VmxFreeBuf(tRec.tVBufCB);
               if (rc <> VIS_OK) then
                 begin
                      VmxReturnCode(rc, ErrTextBuffer);
                      lblStatus.Caption := ErrTextBuffer;
                 end;
            end;

end;

{-----------------------------------------}
{  MoveFirst                              }
{-----------------------------------------}
procedure TfrmMain.MoveFirst;
var
   rc:            Integer;
begin
   rc := VmxBOF(nDatasetNumber, nCurrentIndex);
   MoveNext;
end;

{-----------------------------------------}
{  MoveLast                               }
{-----------------------------------------}
procedure TfrmMain.MoveLast;
var
   rc:            Integer;
begin
   rc := VmxEOF(nDatasetNumber, nCurrentIndex);
   MovePrevious;
end;

{-----------------------------------------}
{  MoveNext                               }
{-----------------------------------------}
procedure TfrmMain.MoveNext;
begin
     MoveToRec(XNEXT);
end;

{-----------------------------------------}
{  MovePrevious                           }
{-----------------------------------------}
procedure TfrmMain.MovePrevious;
begin
     MoveToRec(XPREVIOUS);
end;

{-----------------------------------------}
{  MoveToRec                              }
{-----------------------------------------}
procedure TfrmMain.MoveToRec (MoveOp: Integer);
var
   rc:            Integer;
   ErrTextBuffer: array [0..25] of char;
   PrimaryKey:    array [0..255] of char;
   tRec:          TPerson;
begin
     { MoveOp will be XNEXT or XPREVIOUS }
     rc := VmxGet(nDatasetNumber,     { int    DatasetNumber     }
                  nCurrentIndex,      { int    SelectedIndex     }
                  MoveOp or XTEXT,    { int    OptionParameter   }
                  '',                 { Don't need a Selector param with these options }
                  '',                 { Don't need returned index entry in this case   }
                  PrimaryKey,         { LPSTR  lpPriKey          }
                  @tRec,              { LPVOID lpRecordStructure }
                  sizeof(tRec));      { size of record structure }

     VmxReturnCode(rc, ErrTextBuffer);
     lblStatus.Caption := ErrTextBuffer;

     if (rc = VIS_OK) then
        begin
           { Display the record we got from the database }
           ShowRecord (PrimaryKey, tRec);
           rc := VmxFreeBuf(tRec.tVBufCB);
           if (rc <> VIS_OK) then
              begin
                 VmxReturnCode(rc, ErrTextBuffer);
                 lblStatus.Caption := ErrTextBuffer;
              end;
        end
     else
        { We didn't get a record, which means we're at the beginning/end
          of the database. $0006-MoveOp will move us in the opposite
          direction (i.e. Next becomes Previous and vice versa) so we're
          back on a record again. }
        begin
           rc := VmxGet(nDatasetNumber,  { int    DatasetNumber       }
                  nCurrentIndex,         { int    SelectedIndex       }
                  $0006 - MoveOp         { Move in opposite direction }
                    or XTEXT
                    or XNO_DATA,         { int    OptionParameter     }
                  '',                    { Don't need a Selector param with these options }
                  '',                    { Don't need returned index entry in this case   }
                  PrimaryKey,            { LPSTR  lpPriKey            }
                  @tRec,                 { LPVOID lpRecordStructure   }
                  sizeof(tRec));         { size of record structure   }

           { It's *very* important that you only do FreeBuf if the
             Get call was successful. If Get wasn't successful then
             the pointer being free'd could be anything. }
           if rc = VIS_OK then
             rc := VmxFreeBuf(tRec.tVBufCB)
           else
             begin
                  VmxReturnCode(rc, ErrTextBuffer);
                  lblStatus.Caption := ErrTextBuffer;
             end;
           MessageBeep(0);
        end;
end;

{-----------------------------------------}
{  ShowRecord                             }
{-----------------------------------------}
procedure TfrmMain.ShowRecord (PrimaryKey: PChar; var Person: TPerson);
begin

    { Elements that are an array of chars must use StrPas
      in order to assign them to edit controls }

    frmMain.lblPrimaryKey.Caption := StrPas(PrimaryKey);

    frmMain.txtLastName.Text := Person.LastName;
    frmMain.txtFirstName.Text := Person.FirstName;
    frmMain.txtAddress.Text := Person.Address;
    frmMain.txtCity.Text := StrPas(Person.City);
    frmMain.txtState.Text := StrPas(Person.State);
    frmMain.txtZip.Text := StrPas(Person.Zip);
    frmMain.txtPhone.Text := StrPas(Person.Phone);
    frmMain.txtNotes.Text := StrPas(Person.Notes.lpData);

end;

{-----------------------------------------}
{  Shutdown                               }
{-----------------------------------------}
procedure TfrmMain.Shutdown;
var
   rc: Integer;
   ErrTextBuffer: array [0..25] of char;
begin
     { Close the database on exit }
     if nDatasetNumber <> 0 then
        begin
           rc := VmxClose(nDatasetNumber);
           nDatasetNumber := 0;
           if rc <> VIS_OK then
              begin
                 VmxReturnCode(rc, ErrTextBuffer);
                 lblStatus.Caption := ErrTextBuffer;
                 MessageDlg(ErrTextBuffer, mtWarning, [mbOK], 0);
              end;
        end;

end;

{-----------------------------------------}
{  Startup                                }
{-----------------------------------------}
procedure TfrmMain.Startup;
var
   rc:            Integer;
   ErrTextBuffer: array [0..25] of char;
begin
     { Try to open the file }
     rc := VmxOpen(TPerson_Filename,       { LPSTR lpFilespec       }
                   SMALL_CACHE,            { INT   LocatorSize      }
                   VMODE_RW,               { INT   OpenMode         }
                   nDatasetNumber);        { LPINT lpnDatasetNumber }

     { If we couln't open the file because it wasn't there then
       create a new file }
     if (rc = VIS_DOS_ERROR) then
       begin
         rc := VmxCreate(TPerson_Filename, { LPSTR lpFilespec       }
                         TPerson_MaxKeyLen,{ INT   MaxPrimaryKeyLen }
                         0,                { LONG  GroupSize        }
                         0,                { INT   InitAlloc        }
                         0,                { INT   IncrAlloc        }
                         TPerson_Fmt);     { LPSTR lpFormat         }

         { Open the file we just created }
         if (rc = VIS_OK) then
           begin
             rc := VmxOpen(TPerson_Filename, { LPSTR lpFilespec       }
                           SMALL_CACHE,      { INT   CacheSize        }
                           VMODE_RW,         { INT   OpenMode         }
                           nDatasetNumber);  { LPINT lpnDatasetNumber }
             if rc <> VIS_OK then
                begin
                  VmxReturnCode(rc, ErrTextBuffer);
                  lblStatus.Caption := ErrTextBuffer;
                  MessageDlg(ErrTextBuffer, mtWarning, [mbOK], 0);
                end;
           end;
       end;

end;


end.
